%% Synthetic Time Series
% Martin H. Trauth 2 July 2021
%
% We first clear the workspace and the command window. We then close all
% figure windows.
clear, clc, close all
ds = get(0,'ScreenSize');

%%
% We then load the synthetic data from the file series3.txt. The data
% series contains three main periodicities of 100, 40 and 20 kyrs and
% additive Gaussian noise.
% 
% The amplitudes, however, change through time and the example can
% therefore be used to demonstrate the use of methods to calculate an
% evolutionary power spectrum.
%
% In our example the 40 kyr cycle appears only after ca. 450 kyrs, whereas
% the 100 and 20 kyr cycles are present throughout the time series. We then
% plot the time series.
data = load('series3.txt');

f1 = figure('Position',[50 ds(4)-500 800 300],...
    'Color','w');
axes('Position',[0.1 0.15 0.8 0.7])
line(data(:,1),data(:,2),...
    'LineWidth',1)
xlabel('Age (kyr)')
ylabel('Proxy (unit)')

print(f1,'-dpng','-r300','figure_1_timeseries.png')



